<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Favorite;
use Illuminate\Http\Request;

class FavoriteController extends Controller
{
    public function index()
    {
        $pageTitle = "Favorite Services";
        $favorites = Favorite::where('user_id', auth()->id())->with('service')->orderBy('id', 'desc')->paginate(getPaginate());
        return view($this->activeTemplate .  'user.favorite', compact('pageTitle', 'favorites'));
    }

    public function add(Request $request)
    {
        $favorite = Favorite::where('service_id', $request->id)->where('user_id', auth()->id())->first();
        if ($favorite) {
            $favorite->delete();
            $action = "delete";
        } else {
            $favorite = new Favorite();
            $favorite->service_id = $request->id;
            $favorite->user_id = auth()->id();
            $favorite->save();
            $action = "add";
        }
        return response()->json(
            ['action' => $action]
        );
    }
}
