@extends('admin.layouts.app')

@section('panel')
    @if (@json_decode($general->system_info)->version > systemDetails()['version'])
        <div class="row">
            <div class="col-md-12">
                <div class="card text-white bg-warning mb-3">
                    <div class="card-header">
                        <h3 class="card-title"> @lang('New Version Available') <button class="btn btn--dark float-end">@lang('Version')
                                {{ json_decode($general->system_info)->version }}</button> </h3>
                    </div>
                    <div class="card-body">
                        <h5 class="card-title text--dark">@lang('What is the Update ?')</h5>
                        <p>
                            <pre class="f-size--24">{{ json_decode($general->system_info)->details }}</pre>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    @endif
    @if (@json_decode($general->system_info)->message)
        <div class="row">
            @foreach (json_decode($general->system_info)->message as $msg)
                <div class="col-md-12">
                    <div class="alert border border--primary" role="alert">
                        <div class="alert__icon bg--primary"><i class="far fa-bell"></i></div>
                            <p class="alert__message">@php echo $msg; @endphp</p>
                            <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
            </div>
            @endforeach
        </div>
    @endif
    <div>
        <div class="row gy-4">
            <div class="col-xxl-3 col-sm-6">
                <x-widget
                    link="{{route('admin.users.all')}}"
                    icon="las la-users f-size--56"
                    title="Total Users"
                    value="{{$widget['total_users']}}"
                    bg="primary"
                />
            </div><!-- dashboard-w1 end -->
            <div class="col-xxl-3 col-sm-6">
                <x-widget
                    link="{{route('admin.users.active')}}"
                    icon="las la-user-check f-size--56"
                    title="Active Users"
                    value="{{$widget['verified_users']}}"
                    bg="success"
                />
            </div><!-- dashboard-w1 end -->
            <div class="col-xxl-3 col-sm-6">
                <x-widget
                    link="{{route('admin.users.email.unverified')}}"
                    icon="lar la-envelope f-size--56"
                    title="Email Unverified Users"
                    value="{{$widget['email_unverified_users']}}"
                    bg="danger"
                />
            </div><!-- dashboard-w1 end -->
            <div class="col-xxl-3 col-sm-6">
                <x-widget
                    link="{{route('admin.users.mobile.unverified')}}"
                    icon="las la-comment-slash f-size--56"
                    title="Mobile Unverified Users"
                    value="{{$widget['mobile_unverified_users']}}"
                    bg="red"
                />
            </div><!-- dashboard-w1 end -->
        </div><!-- row end-->

        <div class="row gy-4 mt-2">
            <div class="col-xxl-3 col-sm-6">
                <x-widget
                    style="2"
                    link="{{route('admin.deposit.list')}}"
                    icon="fas fa-hand-holding-usd"
                    icon_style="false"
                    title="Total Deposited"
                    value="{{ $general->cur_sym }}{{showAmount($deposit['total_deposit_amount'])}}"
                    color="success"
                />
            </div><!-- dashboard-w1 end -->
            <div class="col-xxl-3 col-sm-6">
                <x-widget
                    style="2"
                    link="{{route('admin.deposit.pending')}}"
                    icon="fas fa-spinner"
                    icon_style="false"
                    title="Pending Deposits"
                    value="{{$deposit['total_deposit_pending']}}"
                    color="warning"
                />
            </div><!-- dashboard-w1 end -->
            <div class="col-xxl-3 col-sm-6">
                <x-widget
                    style="2"
                    link="{{route('admin.deposit.rejected')}}"
                    icon="fas fa-ban"
                    icon_style="false"
                    title="Rejected Deposits"
                    value="{{$deposit['total_deposit_rejected']}}"
                    color="warning"
                />
            </div><!-- dashboard-w1 end -->
            <div class="col-xxl-3 col-sm-6">
                <x-widget
                    style="2"
                    link="{{route('admin.deposit.list')}}"
                    icon="fas fa-percentage"
                    icon_style="false"
                    title="Deposited Charge"
                    value="{{ $general->cur_sym }}{{showAmount($deposit['total_deposit_charge'])}}"
                    color="primary"
                />
            </div><!-- dashboard-w1 end -->
        </div><!-- row end-->
        <div class="row gy-4 mt-2">
            
            <div class="col-xxl-4 col-sm-6">
                <x-widget
                style="3"
                link="{{ route('admin.orders.index') }}"
                icon="las la-shopping-cart"
                title="Total Order"
                value="{{ $widget['total_order'] }}"
                bg="primary"
            />
            </div><!-- dashboard-w1 end -->

            <div class="col-xxl-4 col-sm-6">
              
                  <x-widget
                    style="3"
                    link="{{ route('admin.orders.pending') }}"
                    icon="las la-spinner"
                    title="Pending Orders"
                    value="{{ $widget['pending_order'] }}"
                    bg="14"
                />
            
            </div><!-- dashboard-w1 end -->

            <div class="col-xxl-4 col-sm-6">
                <x-widget
                style="3"
                link="{{ route('admin.orders.processing') }}"
                icon="la la-refresh"
                title="Processing Orders"
                value="{{ $widget['processing_order'] }}"
                bg="1"
            />
            </div><!-- dashboard-w1 end -->
        </div><!-- row end-->

        <div class="row gy-4 mt-2">
            
            <div class="col-xxl-4 col-sm-6">

 
                    <x-widget
                    style="3"
                    link="{{ route('admin.orders.completed') }}"
                    icon="las la-check-circle"
                    title="Completed Orders"
                    value="{{ $widget['completed_order'] }}"
                    bg="19"
                />
              
            </div><!-- dashboard-w1 end -->

            <div class="col-xxl-4 col-sm-6">
                <x-widget
                style="3"
                link="{{ route('admin.orders.cancelled') }}"
                icon="las la-times-circle"
                title="Cancelled Orders"
                value="{{ $widget['cancelled_order'] }}"
                bg="3"
            />
            
            </div><!-- dashboard-w1 end -->

            <div class="col-xxl-4 col-sm-6">
                <x-widget
                style="3"
                link="{{ route('admin.orders.refunded') }}"
                icon="la la-fast-backward"
                title="Refunded Orders"
                value="{{ $widget['refunded_order'] }}"
                bg="5"
            />
               
            </div><!-- dashboard-w1 end -->


        </div>

        <div class="row mb-none-30 mt-30">
            <div class="col-xl-6 mb-30">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">@lang('Monthly Deposit') (@lang('Last 12 Month'))</h5>
                        <div id="apex-bar-chart"> </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 mb-30">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">@lang('Transactions Report') (@lang('Last 30 Days'))</h5>
                        <div id="apex-line"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-none-30 mt-30">
            <div class="col-xl-12 mb-30">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center flex-wrap">
                            <h5 class="card-title">@lang('Order by API Provider') (@lang('Last 12 Month'))</h5>
                            <select name="provider_id">
                                @foreach ($providers as $provider)
                                    <option value="{{$provider->id}}">{{__($provider->name)}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div id="order-chart"> </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-none-30 mt-5">
            <div class="col-xl-4 col-lg-6 mb-30">
                <div class="card overflow-hidden">
                    <div class="card-body">
                        <h5 class="card-title">@lang('Login By Browser') (@lang('Last 30 days'))</h5>
                        <canvas id="userBrowserChart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-6 mb-30">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">@lang('Login By OS') (@lang('Last 30 days'))</h5>
                        <canvas id="userOsChart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-6 mb-30">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">@lang('Login By Country') (@lang('Last 30 days'))</h5>
                        <canvas id="userCountryChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="cronModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">@lang('Cron Job Setting Instruction')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <h3 class="text--danger text-center">@lang('Please Set Cron Job Now')</h3>
                        <p class="lead">
                            @lang('To automate the api order placement, we need to set the cron job and make sure the cron job is running properly. Set the Cron time as minimum as possible. Once per 5-15 minutes is ideal while once every minute is the best option.') </p>
                        <label class="font-weight-bold">@lang('Cron Command')</label>

                        <div class="input-group mb-3">
                            <input type="text" name="text" class="form-control" id="referralURL"
                                value="curl -s {{ route('cron') }}" readonly>
                            <span class="input-group-text copytext btn btn--primary pt-2 copyBoard" id="copyBoard">
                                @lang('Copy')
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('breadcrumb-plugins')
    @php
        $lastCron = Carbon\Carbon::parse($general->last_cron)->diffInSeconds();
    @endphp
    <span
        class=" @if ($lastCron < 300) text--info @elseif($lastCron < 900) text--warning @else text--danger @endif ">
        @lang('Last Cron Run')
        <strong>{{ diffForHumans($general->last_cron) }}</strong>
    </span>
@endpush
@push('script')
    <script src="{{ asset('assets/viseradmin/js/vendor/apexcharts.min.js') }}"></script>
    <script src="{{ asset('assets/viseradmin/js/vendor/chart.js.2.8.0.js') }}"></script>
    <script>
        (function($) {
            "use strict";
            @if (Carbon\Carbon::parse($general->last_cron)->diffInMinutes() > 15)
                window.onload = () => {
                    $('#cronModal').modal('show');
                }
            @endif

            $('.copyBoard').on('click', function() {
                var copyText = document.getElementById("referralURL");
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                document.execCommand("copy");
                iziToast.success({
                    message: "Copied: " + copyText.value,
                    position: "topRight"
                });
            });

        })(jQuery);
    </script>


    <script>
        "use strict";
        var options = {
            series: [{
                name: 'Total Deposit',
                data: [
                    @foreach ($months as $month)
                        {{ getAmount(@$depositsMonth->where('months', $month)->first()->depositAmount) }},
                    @endforeach
                ]
            }],
            chart: {
                type: 'bar',
                height: 450,
                toolbar: {
                    show: false
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '50%',
                    endingShape: 'rounded'
                },
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                show: true,
                width: 2,
                colors: ['transparent']
            },
            xaxis: {
                categories: @json($months),
            },
            yaxis: {
                title: {
                    text: "{{ __($general->cur_sym) }}",
                    style: {
                        color: '#7c97bb'
                    }
                }
            },
            grid: {
                xaxis: {
                    lines: {
                        show: false
                    }
                },
                yaxis: {
                    lines: {
                        show: false
                    }
                },
            },
            fill: {
                opacity: 1
            },
            tooltip: {
                y: {
                    formatter: function(val) {
                        return "{{ __($general->cur_sym) }}" + val + " "
                    }
                }
            }
        };
        var chart = new ApexCharts(document.querySelector("#apex-bar-chart"), options);
        chart.render();



        var ctx = document.getElementById('userBrowserChart');
        var myChart = new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: @json($chart['user_browser_counter']->keys()),
                datasets: [{
                    data: {{ $chart['user_browser_counter']->flatten() }},
                    backgroundColor: [
                        '#ff7675',
                        '#6c5ce7',
                        '#ffa62b',
                        '#ffeaa7',
                        '#D980FA',
                        '#fccbcb',
                        '#45aaf2',
                        '#05dfd7',
                        '#FF00F6',
                        '#1e90ff',
                        '#2ed573',
                        '#eccc68',
                        '#ff5200',
                        '#cd84f1',
                        '#7efff5',
                        '#7158e2',
                        '#fff200',
                        '#ff9ff3',
                        '#08ffc8',
                        '#3742fa',
                        '#1089ff',
                        '#70FF61',
                        '#bf9fee',
                        '#574b90'
                    ],
                    borderColor: [
                        'rgba(231, 80, 90, 0.75)'
                    ],
                    borderWidth: 0,

                }]
            },
            options: {
                aspectRatio: 1,
                responsive: true,
                maintainAspectRatio: true,
                elements: {
                    line: {
                        tension: 0 // disables bezier curves
                    }
                },
                scales: {
                    xAxes: [{
                        display: false
                    }],
                    yAxes: [{
                        display: false
                    }]
                },
                legend: {
                    display: false,
                }
            }
        });



        var ctx = document.getElementById('userOsChart');
        var myChart = new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: @json($chart['user_os_counter']->keys()),
                datasets: [{
                    data: {{ $chart['user_os_counter']->flatten() }},
                    backgroundColor: [
                        '#ff7675',
                        '#6c5ce7',
                        '#ffa62b',
                        '#ffeaa7',
                        '#D980FA',
                        '#fccbcb',
                        '#45aaf2',
                        '#05dfd7',
                        '#FF00F6',
                        '#1e90ff',
                        '#2ed573',
                        '#eccc68',
                        '#ff5200',
                        '#cd84f1',
                        '#7efff5',
                        '#7158e2',
                        '#fff200',
                        '#ff9ff3',
                        '#08ffc8',
                        '#3742fa',
                        '#1089ff',
                        '#70FF61',
                        '#bf9fee',
                        '#574b90'
                    ],
                    borderColor: [
                        'rgba(0, 0, 0, 0.05)'
                    ],
                    borderWidth: 0,

                }]
            },
            options: {
                aspectRatio: 1,
                responsive: true,
                elements: {
                    line: {
                        tension: 0 // disables bezier curves
                    }
                },
                scales: {
                    xAxes: [{
                        display: false
                    }],
                    yAxes: [{
                        display: false
                    }]
                },
                legend: {
                    display: false,
                }
            },
        });


        // Donut chart
        var ctx = document.getElementById('userCountryChart');
        var myChart = new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: @json($chart['user_country_counter']->keys()),
                datasets: [{
                    data: {{ $chart['user_country_counter']->flatten() }},
                    backgroundColor: [
                        '#ff7675',
                        '#6c5ce7',
                        '#ffa62b',
                        '#ffeaa7',
                        '#D980FA',
                        '#fccbcb',
                        '#45aaf2',
                        '#05dfd7',
                        '#FF00F6',
                        '#1e90ff',
                        '#2ed573',
                        '#eccc68',
                        '#ff5200',
                        '#cd84f1',
                        '#7efff5',
                        '#7158e2',
                        '#fff200',
                        '#ff9ff3',
                        '#08ffc8',
                        '#3742fa',
                        '#1089ff',
                        '#70FF61',
                        '#bf9fee',
                        '#574b90'
                    ],
                    borderColor: [
                        'rgba(231, 80, 90, 0.75)'
                    ],
                    borderWidth: 0,

                }]
            },
            options: {
                aspectRatio: 1,
                responsive: true,
                elements: {
                    line: {
                        tension: 0 // disables bezier curves
                    }
                },
                scales: {
                    xAxes: [{
                        display: false
                    }],
                    yAxes: [{
                        display: false
                    }]
                },
                legend: {
                    display: false,
                }
            }
        });

        // apex-line chart
        var options = {
            chart: {
                height: 450,
                type: "area",
                toolbar: {
                    show: false
                },
                dropShadow: {
                    enabled: true,
                    enabledSeries: [0],
                    top: -2,
                    left: 0,
                    blur: 10,
                    opacity: 0.08
                },
                animations: {
                    enabled: true,
                    easing: 'linear',
                    dynamicAnimation: {
                        speed: 1000
                    }
                },
            },
            dataLabels: {
                enabled: false
            },
            series: [{
                    name: "Plus Transactions",
                    data: [
                        @foreach ($trxReport['date'] as $trxDate)
                            {{ @$plusTrx->where('date', $trxDate)->first()->amount ?? 0 }},
                        @endforeach
                    ]
                },
                {
                    name: "Minus Transactions",
                    data: [
                        @foreach ($trxReport['date'] as $trxDate)
                            {{ @$minusTrx->where('date', $trxDate)->first()->amount ?? 0 }},
                        @endforeach
                    ]
                }
            ],
            fill: {
                type: "gradient",
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.7,
                    opacityTo: 0.9,
                    stops: [0, 90, 100]
                }
            },
            xaxis: {
                categories: [
                    @foreach ($trxReport['date'] as $trxDate)
                        "{{ $trxDate }}",
                    @endforeach
                ]
            },
            grid: {
                padding: {
                    left: 5,
                    right: 5
                },
                xaxis: {
                    lines: {
                        show: false
                    }
                },
                yaxis: {
                    lines: {
                        show: false
                    }
                },
            },
        };

        var chart = new ApexCharts(document.querySelector("#apex-line"), options);
        chart.render();


        // Api provider order chart
        $('[name=provider_id]').on('change',function(){
            var providerId = $(this).val();
            $.ajax({
                type: "GET",
                url: `{{route('admin.provider.chart')}}/${providerId}`,
                success: function (response) {
                    $('#order-chart').html('');
                    var options = {
                        series: [
                            {
                                name: 'Total',
                                data: Object.values(response),
                            }
                        ],
                        chart: {
                        type: 'bar',
                        height: 400,
                        toolbar: {
                                show: false
                            }
                        },
                        plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                        },
                        dataLabels: {
                        enabled: false
                        },
                        stroke: {
                        show: true,
                        width: 1,
                        colors: ['transparent']
                        },
                        xaxis: {
                        categories: Object.keys(response)
                        },
                        fill: {
                        opacity: 1
                        },
                        tooltip: {
                        y: {
                            formatter: function (val) {
                            return val.toFixed(2) + " {{ $general->cur_text }}"
                            }
                        }
                        }
                        };
                        var orderChart = new ApexCharts(document.querySelector("#order-chart"), options);
                        orderChart.render();
                }
            });
        }).change()
      
    </script>
@endpush
