<header class="header fixed-header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="{{route('home')}}"><img src="{{ siteLogo(2) }}" alt="Site Logo"></a>
            <button class="navbar-toggler header-button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" type="button" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="navbar-collapse collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu primary-nav align-items-lg-center justify-content-end flex-grow-1 ms-auto">
                    <li class="nav-item {{ menuActive('home') }}">
                        <a class="nav-link" href="{{ route('home') }}" aria-current="page">@lang('Home')</a>
                    </li>
                    @foreach ($pages as $k => $data)
                        <li class="nav-item {{ menuActive('pages', [$data->slug]) }}">
                            <a class="nav-link" href="{{ route('pages', [$data->slug]) }}" aria-current="page">{{ __($data->name) }}</a>
                        </li>
                    @endforeach
                    <li class="nav-item {{ menuActive('blog') }}">
                        <a class="nav-link" href="{{ route('blog') }}" aria-current="page"> @lang('Blog') </a>
                    </li>
                    <li class="nav-item {{ menuActive('contact') }}">
                        <a class="nav-link" href="{{ route('contact') }}" aria-current="page"> @lang('Contact') </a>
                    </li>

                </ul>


                <div class="top-button nav-item d-lg-none flex-between align-items-center">
                    <ul class="login-registration-list d-flex align-items-center flex-wrap">
                        @guest
                            <li class="login-registration-list__item login">
                                <a class="login-registration-list__link" href="{{ route('user.login') }}"> @lang('Sign In')</a>
                            </li>
                            <li class="login-registration-list__item get-start"><a class="login-registration-list__link btn btn--base nav-btn" href="{{ route('user.register') }}"> @lang('Get Started') </a></li>
                        @endguest

                        @auth
                            <li class="login-registration-list__item get-start"><a class="login-registration-list__link btn btn--base nav-btn" href="{{ route('user.home') }}"> @lang('Dashboard') </a></li>
                            <li class="login-registration-list__item login">
                                <a class="login-registration-list__link" href="{{ route('user.logout') }}"> @lang('Logout')</a>
                            </li>
                        @endauth
                    </ul>
                </div>

                <!-- Login Button Start -->
                <ul class="navbar-nav nav-menu align-items-lg-center d-none d-lg-flex ms-auto">
                    @auth

                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('user.logout') }}"> @lang('Logout') </a>
                        </li>
                        <li class="nav-item">
                            <a class="btn btn--base nav-btn d-inline" href="{{ route('user.home') }}"> @lang('Dashboard') </a>
                        </li>
                    @endauth
                    @guest
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('user.login') }}"> @lang('Sign In') </a>
                        </li>
                        <li class="nav-item">
                            <a class="btn btn--base nav-btn d-inline" href="{{ route('user.register') }}"> @lang('Get Started') </a>
                        </li>
                    @endguest
                </ul>
                <!-- Login Button End -->
            </div>
        </nav>
    </div>
</header>
