@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $registerContent = getContent('register.content', true);
        $policyPages = getContent('policy_pages.element', false, null, true);
    @endphp

<section class="account">
    <div class="account-content">
        <div class="account-logo">
            <div class="container">
                <a href="{{ route('home') }}">
                    <img src="{{ siteLogo(2) }}" alt="site-logo">
                </a>
            </div>
        </div>
        <div class="account-form">
            <div class="row justify-content-center">
                <div class="col-lg-8 col-md-10">
                    <div class="account-form__content text-center">
                        <h2 class="account-form__title mb-2"> {{ __($registerContent->data_values->heading) }} </h2>
                        <p class="account-form__desc"> {{ __($registerContent->data_values->sub_heading) }} </p>
                    </div>
                    <form class="verify-gcaptcha" action="{{ route('user.register') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                <div class="form--group">
                                    <label class="form--label"> @lang('Username')</label>
                                    <input class="form--control checkUser" name="username" type="text" value="{{ old('username') }}" required>
                                    <small class="text-danger usernameExist"></small>
                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                <div class="form--group">
                                    <label class="form--label">@lang('E-Mail Address')</label>
                                    <input class="form--control checkUser" name="email" type="email" value="{{ old('email') }}" required>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                <div class="form--group">
                                    <label class="form--label">@lang('Country')</label>
                                    <select class="form--control" name="country">
                                        @foreach ($countries as $key => $country)
                                            <option data-mobile_code="{{ $country->dial_code }}" data-code="{{ $key }}" value="{{ $country->country }}">{{ __($country->country) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                <div class="form--group">
                                    <label class="form--label">@lang('Mobile')</label>
                                    <div class="input-group">
                                        <span class="input-group-text mobile-code">
                                        </span>
                                        <input name="mobile_code" type="hidden">
                                        <input name="country_code" type="hidden">
                                        <input class="form-control form--control checkUser" name="mobile" type="number" value="{{ old('mobile') }}" required>
                                    </div>
                                    <small class="text-danger mobileExist"></small>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                <label class="form--label">@lang('Password')</label>
                                <div class="position-relative">
                                    <input class="form--control @if ($general->secure_password) secure-password @endif" id="your-password" name="password" type="password" required>
                                    <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash" id="#your-password"></span>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                <label class="form--label" for="confirm-password">@lang('Confirm Password')</label>
                                <div class="position-relative">
                                    <input class="form--control" id="confirm-password" name="password_confirmation" type="password" required>
                                    <div class="password-show-hide fas fa-eye toggle-password fa-eye-slash" id="#confirm-password">
                                    </div>
                                </div>
                            </div>

                            <x-captcha />

                            <div class="form-group flex-wrap">
                                <div class="form--check">
                                    <input class="form-check-input" id="agree" name="agree" type="checkbox" @checked(old('agree')) required>
                                </div>
                                <div class="terms px-2">
                                    <label class="form-check-label" for="agree"> @lang('I agree with') </label>
                                    @foreach ($policyPages as $policy)
                                        <a class="contact-form__link" href="{{ route('policy.pages', [slug($policy->data_values->title), $policy->id]) }}" target="_blank">{{ __($policy->data_values->title) }}</a>
                                        @if (!$loop->last)
                                            ,
                                        @endif
                                    @endforeach
                                </div>
                            </div>

                            <div class="col-sm-12 form-group">
                                <button class="btn btn--base w-100" type="submit"> @lang('Sign Up') </button>
                            </div>
                            <div class="col-sm-12">
                                <div class="have-account text-center">
                                    <p class="have-account__text"> @lang('Already Have An Account?') <a class="have-account__link" href="{{ route('user.login') }}"> @lang('Sign In') </a></p>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="account-copyright">
                <span class="fs-12 account-copyright__text">
                    @lang('Copyright') &copy; {{ date('Y') }}. @lang('All Rights Reserved By') <a class="t-link" href="{{ route('home') }}">{{ __($general->site_name) }}</a>
                </span>
        </div>
    </div>
    <div class="account-thumb">
        <img src="{{ getImage('assets/images/frontend/register/' . @$registerContent->data_values->image, '960x965') }}">
    </div>
</section>

    <div class="modal custom--modal fade" id="existModalCenter" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center m-0">@lang('You already have an account please Login ')</h6>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-dark btn--sm" data-bs-dismiss="modal" type="button">@lang('Close')</button>
                    <a class="btn btn--base btn--sm" href="{{ route('user.login') }}">@lang('Login')</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .country-code .input-group-text {
            background: #fff !important;
        }

        .country-code select {
            border: none;
        }

        .country-code select:focus {
            border: none;
            outline: none;
        }
    </style>
@endpush
@if ($general->secure_password)
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif
@push('script')
    <script>
        "use strict";
        (function($) {
            @if ($mobileCode)
                $(`option[data-code={{ $mobileCode }}]`).attr('selected', '');
            @endif

            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));

            $('.checkUser').on('focusout', function(e) {
                var url = '{{ route('user.checkUser') }}';
                var value = $(this).val();
                var token = '{{ csrf_token() }}';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
